
// variable to store our intervalID

let POS_ALL = 0;
let POS_TL  = 1;
let POS_TR  = 2;
let POS_BL  = 3;
let POS_BR  = 4;
let POS_MD  = 5;

let POS_WLAN = POS_TL;
let POS_ETH0 = POS_TR;
let POS_VPN  = POS_BL;
let POS_ENC  = POS_BR;
let POS_NETW = POS_MD;

let WHITE   = 0;
let RED     = 1;
let GREEN   = 2;
let BLUE    = 3;
let YELLOW  = 4;

let OFF     = 0;
let ON      = 1;

let WEB_VER_home_css      = 0;
let WEB_VER_home          = 0;
let WEB_VER_index_css     = 0;
let WEB_VER_index         = 0;
let WEB_VER_info_css      = 0;
let WEB_VER_info          = 0;
let WEB_VER_login         = 0;
let WEB_VER_logintest     = 0;
let WEB_VER_logs_css      = 0;
let WEB_VER_logs          = 0;
let WEB_VER_readsettings  = 0;
let WEB_VER_settings_css  = 0;
let WEB_VER_settings      = 0;
let WEB_VER_js            = 0;
let WEB_VER_ajax          = 0;
let WEB_VER_style_css     = 0;
let WEB_VER_vers          = 0;

let WEB_VER_app           = 0;
let WEB_VER_os            = 0;
let WEB_VER_vpn           = 0;

let WEB_FLASH_count   = 0;
let WEB_FLASH         = 0;

let PAT_OFF             = 0;
let PAT_ROTATE_CW       = 1;
let PAT_ROTATE_ACW      = 2;
let PAT_RANDOM          = 3;
let PAT_ROTATE_TOP      = 4;
let PAT_ROTATE_BOT      = 5;
let PAT_ALT_TOP_MID     = 6;
let PAT_ALT_BOT_MID     = 7;
let PAT_ALT_TOP_MID_BOT = 8;
let PAT_ALT_L_MID_R     = 9;

let AJAX_REQUEST_RATE   = 750;
let LED_UPDATE_RATE     = 150;

let WEAREUPDATING = false;
let formready = OFF;
let allstates = '0,0,0,0,0,0,0,0,0';

let LED_rotationcount   = 0;
let LED_sequencenum     = 0;

let LED_stop            = 10;// Fixed values we can trigger on
let LED_done            = 5;// Fixed values we can trigger on

let LED_patternnum      = PAT_ROTATE_CW;
let LED_rotatecolor     = RED;
let DOT_color           = 'green';

let FULL_screen         = 0;

let nIntervId;
let LEDIntervId;
let nreadbackId;

let SHIELD_currentteststep = 0;

let SHIELD_STATE_NOTRUNNING     = 0;
let SHIELD_STATE_REBOOTING      = 1;
let SHIELD_STATE_RESTARTING     = 2;
let SHIELD_STATE_STARTING       = 3;
let SHIELD_STATE_RUNNING        = 4;
let SHIELD_STATE_CTRLC          = 5;
let SHIELD_STATE_DRIVEEDIT      = 6;
let SHIELD_STATE_DRIVECFG       = 7;
let SHIELD_STATE_UPDATING       = 8;
let SHIELD_STATE_TIMEERROR      = 9;

let SHIELD_STATE                = SHIELD_STATE_NOTRUNNING;

let LASTTIMEWAS = '00:00:00';
let READAGAINTIMEOUT = 5;

var elem = document.documentElement;

//screen.orientation.lock('landscape');

function T2S(duration){
  var mysplit = duration.split(':');
  return Number(mysplit[0]) * 60 * 60 + Number(mysplit[1]) * 60 + Number(mysplit[2]);
}

function doreadback(){
  if(DiD('ShieldSetting_01_lbl')){settingsread();}
}          


function nothing(){}
function loadlog(){}

function log_up(){
  let tagid = 'log_filename_list'
  var myEle = DiD(tagid);
  var x = 0;
  if(myEle){
    x = myEle.selectedIndex;
    if (x > 0) {x = x - 1;}
    myEle.selectedIndex = x;
  }
  logswitch();
}

function log_down(){
  let tagid = 'log_filename_list'
  var myEle = DiD(tagid);
  var x = 0;
  if(myEle){
    x = myEle.selectedIndex;
    if (x < myEle.options.length - 1){x = x + 1;}
    myEle.selectedIndex = x;
  }
  logswitch();  
}

function toggle_dropdown(){
  var tagid = 'menucontent';
  var myEle = DiD(tagid);
  if(myEle){
    if(myEle.style.display == 'block'){
      myEle.style.display = null;
    } else {  
      myEle.style.display = 'block';
    }
  }  
}

function showsizes(){
  var tagid = 'sizes';
  var myEle = DiD(tagid);
  if(myEle){
    myEle.innerHTML = "W: " + window.innerWidth + "px x H: " + window.innerHeight + "px";
  }
}

function toggle_FULL(){
//  if(FULL_screen == 1){
//    closeFullscreen();
//  } else {
//    openFullscreen();
//  }
  if (document.fullscreenElement){
    document
      .exitFullscreen()
      .then(() => console.log("Document Exited from Full screen mode"))
      .catch((err) => console.error(err));
  } else {
    document.documentElement.requestFullscreen();
  }
}

function openFullscreen(){
  FULL_screen = 1;
  if (elem.requestFullscreen){
    elem.requestFullscreen();
  } else if (elem.webkitRequestFullscreen){ /* Safari */
    elem.webkitRequestFullscreen();
  } else if (elem.msRequestFullscreen){ /* IE11 */
    elem.msRequestFullscreen();
  }
}

function closeFullscreen(){
  FULL_screen = 0;
  if (document.exitFullscreen){
    document.exitFullscreen();
  } else if (document.webkitExitFullscreen){ /* Safari */
    document.webkitExitFullscreen();
  } else if (document.msExitFullscreen){ /* IE11 */
    document.msExitFullscreen();
  }
}

function reloadpage(d){
  window.location = d;
}

function showVersions(){
  var tagid = 'table_WEB_VERS';
  var myEle = DiD(tagid);
  if(myEle){
    if(myEle.style.display == 'block'){
      myEle.style.display = null;
    } else {  
      myEle.style.display = 'block';
    }
  }  
}

function reddot(y){
  var tagid = 'dotred';
  var myEle = DiD(tagid);
  if(myEle){
    myEle.style.backgroundColor = DOT_color;
    if(y == ON){
      myEle.style.display = 'block';
    } else {  
      myEle.style.display = 'none';
    }
  }  
}

function fanMode(y){
  var tagid = 'fan';
  var myEle = DiD(tagid);
  var myEle_point = DiD(tagid+'_pointer');
  if(myEle){
    if(y == ON){
      myEle.style.display = 'block';
      if(myEle_point){myEle_point.style.display = 'block';}
    } else {  
      myEle.style.display = 'none';
      if(myEle_point){myEle_point.style.display = 'none';}
    }
  }
}

function SET_logoMain(i, y){
  var tagid = 'logo';
  var myEle = DiD(tagid);
  if(myEle){
    SET_logo('logo', 'logo' + i + '.svg');
    if(y == ON){
      myEle.style.display = 'block';
    } else {
      myEle.style.display = 'none'; 
    }
  }
}  

function LED_SetColor(l, c){
  let ll = "";
  let cc = "";
  if(l==POS_TL) {ll = "tl";}
  if(l==POS_TR) {ll = "tr";}
  if(l==POS_BL) {ll = "bl";}
  if(l==POS_BR) {ll = "br";}
  if(l==POS_MD) {ll = "mid";}
  
  if(c==WHITE)  {cc = "white";}
  if(c==RED)    {cc = "red";}
  if(c==GREEN)  {cc = "green";}
  if(c==BLUE)   {cc = "blue";}
  if(c==YELLOW) {cc = "yellow";}
  
  SET_logo('logo_led_' + l, ll + '_' + cc + '.svg');
//  SET_logo('logo_led_' + l,'logo_' + l + '_' + c + '.svg');
}

function LED_ShowHide(l, y){
  var tagid = 'logo_led_' + l;
  var myEle = DiD(tagid);
  if(myEle){
    if(y == ON){
      myEle.style.display = 'block';
    } else {
      myEle.style.display = 'none';
    }
  }
}

function LED_AllSetColor(c){
  if(LED_sequencenum + LED_rotationcount == 0){
    LED_SetColor(POS_TL,c);
    LED_SetColor(POS_TR,c);
    LED_SetColor(POS_BL,c);
    LED_SetColor(POS_BR,c);
    LED_SetColor(POS_MD,c);
  }
}

function LED_AllShow(y){
  LED_ShowHide(POS_TL, y);
  LED_ShowHide(POS_TR, y);
  LED_ShowHide(POS_BL, y);
  LED_ShowHide(POS_BR, y);
  LED_ShowHide(POS_MD, y);
}

function SET_logo(e, l){
  var myEle = DiD(e);
  if(myEle){
    if(myEle.src.includes(l)){return;}
    myEle.src = './public/external/logos/' + l;
  }
}

function dospanner(){
  if(nIntervId){
    shieldCommand_GET('0');
  }
  nIntervId = setTimeout(dospanner, AJAX_REQUEST_RATE);
  showsizes();
}

function LEDS_timer(){  
  if(LEDIntervId){
    FillStates();
    whatstate();
    LED_FancyWork()
  }
  LEDIntervId = setTimeout(LEDS_timer, LED_UPDATE_RATE);
}

function LEDS_patterns(){
  if(LED_rotationcount >= LED_done){
    LED_rotationcount = LED_stop;
    LED_sequencenum = 0;
    LED_AllShow(ON);
    return;
  }

  LED_AllSetColor(LED_rotatecolor);
  LED_AllShow(OFF);
  LED_sequencenum++;  

  if(LED_patternnum == PAT_ROTATE_CW)       {PATTERN_rotate_cw();       return;}
  if(LED_patternnum == PAT_ROTATE_ACW)      {PATTERN_rotate_acw();      return;}
  if(LED_patternnum == PAT_RANDOM)          {PATTERN_random();          return;}
  if(LED_patternnum == PAT_ROTATE_TOP)      {PATTERN_rotate_top();      return;}
  if(LED_patternnum == PAT_ROTATE_BOT)      {PATTERN_rotate_bot();      return;}
  if(LED_patternnum == PAT_ALT_TOP_MID)     {PATTERN_alt_top_mid();     return;}
  if(LED_patternnum == PAT_ALT_BOT_MID)     {PATTERN_alt_bot_mid();     return;}
  if(LED_patternnum == PAT_ALT_TOP_MID_BOT) {PATTERN_alt_top_mid_bot(); return;}
  if(LED_patternnum == PAT_ALT_L_MID_R)     {PATTERN_alt_l_mid_r();     return;}
}

function PATTERN_rotate_cw(){
  if(LED_sequencenum == 1){LED_ShowHide(POS_TL, ON);}
  if(LED_sequencenum == 2){LED_ShowHide(POS_TR, ON);}
  if(LED_sequencenum == 3){LED_ShowHide(POS_BR, ON);}
  if(LED_sequencenum == 4){
    LED_ShowHide(POS_BL, ON);
    LED_sequencenum = 0;
    LED_rotationcount++;
  }  
}

function PATTERN_rotate_acw(){
  if(LED_sequencenum == 1){LED_ShowHide(POS_TL, ON);}
  if(LED_sequencenum == 2){LED_ShowHide(POS_BL, ON);}
  if(LED_sequencenum == 3){LED_ShowHide(POS_BR, ON);}
  if(LED_sequencenum == 4){
    LED_ShowHide(POS_TR, ON);
    LED_sequencenum = 0;
    LED_rotationcount++;
  }  
}

function PATTERN_random(){
  LED_sequencenum = 1;
  LED_rotationcount++;
  let num1 = Math.floor(Math.random() * 5) + 1;
  let num2 = Math.floor(Math.random() * 5) + 1;
  LED_ShowHide(num1, ON);
  LED_ShowHide(num2, ON);  
}

function PATTERN_rotate_top(){
  if(LED_sequencenum == 1){LED_ShowHide(POS_TL, ON);}
  if(LED_sequencenum == 2){LED_ShowHide(POS_TR, ON);}
  if(LED_sequencenum == 3){
    LED_ShowHide(POS_MD, ON);
    LED_sequencenum = 0;
    LED_rotationcount++;
  }
}

function PATTERN_rotate_bot(){
  if(LED_sequencenum == 1){LED_ShowHide(POS_BL, ON);}
  if(LED_sequencenum == 2){LED_ShowHide(POS_BR, ON);}
  if(LED_sequencenum == 3){
    LED_ShowHide(POS_MD, ON);
    LED_sequencenum = 0;
    LED_rotationcount++;
  }  
}

function PATTERN_alt_top_mid(){
  if(LED_sequencenum == 1){
    LED_ShowHide(POS_TL, ON); 
    LED_ShowHide(POS_TR, ON);
  }
  if(LED_sequencenum == 2){
    LED_ShowHide(POS_MD, ON);
    LED_sequencenum = 0;
    LED_rotationcount++;
  }  
}

function PATTERN_alt_bot_mid(){
  if(LED_sequencenum == 1){
    LED_ShowHide(POS_BL, ON); 
    LED_ShowHide(POS_BR, ON);
  }
  if(LED_sequencenum == 2){
    LED_ShowHide(POS_MD, ON);
    LED_sequencenum = 0;
    LED_rotationcount++;
  }  
}

function PATTERN_alt_top_mid_bot(){
  if(LED_sequencenum == 1){
    LED_ShowHide(POS_TL, ON);
    LED_ShowHide(POS_TR, ON);
  }
  if(LED_sequencenum == 2){LED_ShowHide(POS_MD, ON);}
  if(LED_sequencenum == 3){
    LED_ShowHide(POS_BL, ON);
    LED_ShowHide(POS_BR, ON);
    LED_sequencenum = 0;
    LED_rotationcount++;
  }  
}

function PATTERN_alt_l_mid_r(){
  if(LED_sequencenum == 1){LED_ShowHide(POS_TL, ON); LED_ShowHide(POS_BL, ON);}
  if(LED_sequencenum == 2){LED_ShowHide(POS_MD, ON);}
  if(LED_sequencenum == 3){
    LED_ShowHide(POS_TR, ON); LED_ShowHide(POS_BR, ON);
    LED_sequencenum = 0;
    LED_rotationcount++;
  }
}

function FillStates(){
  var statearray = allstates.split(',');
//let SHIELD_allstates = '0,3,3,0,2,1,46.2,47.5,0,5,99,0,1';
// SHIELD_apmode = statearray[0];; = statearray[0];
//let SHIELD_wlan0 = 'Up'; = statearray[1];
//let SHIELD_eth0 = 'Cable Good'; = statearray[2];
//let SHIELD_vpn = 'Not Running'; = statearray[3];
//let SHIELD_enc = 'Not Tested'; = statearray[4];
//let SHIELD_network = 'OK'; = statearray[5];
//let SHIELD_gputemp = '46.2Â°C'; = statearray[6];
//let SHIELD_soctemp = '47.5Â°C'; = statearray[7];

  if(statearray[8] == OFF){fanMode(OFF);}
  if(statearray[8] == ON) {fanMode(ON);}
  SHIELD_currentteststep = statearray[9];

//  WIFISTEP,  = statearray[10];
//  NEW_CONFIG,   = statearray[11];
//  mySettings.VALID  = statearray[12];
}

function ShowStates(){
  LED_CheckState(POS_TL);  // WLAN0
  LED_CheckState(POS_TR);  // ETH0
  LED_CheckState(POS_BL);  // VPN  
  LED_CheckState(POS_BR);  // ENC
  LED_CheckState(POS_MD);  // NETWORK  
}

function LED_FancyWork(){
// 0 = OK
// 1 = wdt
// 2 = WLAN  POS_WLAN
// 3 = ETH0  POS_ETH0
// 4 = VPN,  POS_VPN
// 5 = ENC,  POS_ENC
// 6 = NET,  POS_NETW
// 7 = CFG,
// 8 = FAN
  if (SHIELD_STATE == SHIELD_STATE_RUNNING){
    ShowStates();
    return;
  }

  if (SHIELD_STATE == SHIELD_STATE_STARTING){
	return
   // if(SHIELD_currentteststep >= 2){LED_CheckState(POS_WLAN)}
   // if(SHIELD_currentteststep >= 3){LED_CheckState(POS_ETH0)}
   // if(SHIELD_currentteststep >= 4){LED_CheckState(POS_ENC)}
   // if(SHIELD_currentteststep >= 5){LED_CheckState(POS_VPN)}
   // if(SHIELD_currentteststep >= 6){LED_CheckState(POS_NETW)}
    
   // if(SHIELD_currentteststep < 6){LED_SetColor(POS_NETW,LED_rotatecolor);}
   // if(SHIELD_currentteststep < 5){LED_SetColor(POS_VPN,LED_rotatecolor);}
   // if(SHIELD_currentteststep < 4){LED_SetColor(POS_ENC,LED_rotatecolor);}
   // if(SHIELD_currentteststep < 3){LED_SetColor(POS_ETH0,LED_rotatecolor);}
   // if(SHIELD_currentteststep < 2){LED_SetColor(POS_WLAN,LED_rotatecolor);}

    LED_AllShow(ON);
   // LED_sequencenum++;  
   // if(LED_patternnum == PAT_ROTATE_CW)       {PATTERN_rotate_cw();       return;}
   // if(LED_patternnum == PAT_ROTATE_ACW)      {PATTERN_rotate_acw();      return;}
   // if(LED_patternnum == PAT_RANDOM)          {PATTERN_random();          return;}
   // if(LED_patternnum == PAT_ROTATE_TOP)      {PATTERN_rotate_top();      return;}
   // if(LED_patternnum == PAT_ROTATE_BOT)      {PATTERN_rotate_bot();      return;}
   // if(LED_patternnum == PAT_ALT_TOP_MID)     {PATTERN_alt_top_mid();     return;}
   // if(LED_patternnum == PAT_ALT_BOT_MID)     {PATTERN_alt_bot_mid();     return;}
   // if(LED_patternnum == PAT_ALT_TOP_MID_BOT) {PATTERN_alt_top_mid_bot(); return;}
   // if(LED_patternnum == PAT_ALT_L_MID_R)     {PATTERN_alt_l_mid_r();     return;}
    return
  }

  if(LED_rotationcount <= LED_done){
    LEDS_patterns();
  }

}

function LED_CheckState(ledID){
  var statearray = allstates.split(',');
  if (ledID == POS_TL){     // WLAN0
    if(statearray[1] == 0){LED_SetColor(POS_TL, RED);}    //missing
    if(statearray[1] == 1){LED_SetColor(POS_TL, RED);}  //off
    if(statearray[1] == 2){LED_SetColor(POS_TL, RED);}    //disconnected
    if(statearray[1] == 3){LED_SetColor(POS_TL, GREEN);}  //online
  }

  if (ledID == POS_TR){     // ETH0
    if(statearray[2] == 0){LED_SetColor(POS_TR, RED);}    //missing
    if(statearray[2] == 1){LED_SetColor(POS_TR, RED);}  //off
    if(statearray[2] == 2){LED_SetColor(POS_TR, RED);}    //disconnected
    if(statearray[2] == 3){LED_SetColor(POS_TR, GREEN);}  //online
  }

  if (ledID == POS_BL){     // VPN
    if(statearray[3] == 0){LED_SetColor(POS_BL, RED);}    //Fail
    if(statearray[3] == 1){LED_SetColor(POS_BL, GREEN);}  //on
    if(statearray[3] == 2){LED_SetColor(POS_BL, RED);}    //notest
  }
  
  if (ledID == POS_BR){     // ENC
    if(statearray[4] == 0){LED_SetColor(POS_BR, RED);}    //offline
    if(statearray[4] == 1){LED_SetColor(POS_BR, GREEN);}  //on
    if(statearray[4] == 2){LED_SetColor(POS_BR, RED);}    //notest
  }
  
  if (ledID == POS_MD){     // NETWORK
    if(statearray[5] == 0){LED_SetColor(POS_MD, RED);}    //offline
    if(statearray[5] == 1){LED_SetColor(POS_MD, GREEN);}  //OK
    if(statearray[5] == 2){LED_SetColor(POS_MD, RED);}    //notest
  }
}

function whatstate(){
  if(formready == ON){  
    var tagid = 'SHIELD_state';
    var myEle = DiD(tagid);
    if(myEle){
      
      if(myEle.innerHTML == 'Fan ON')       {return;}
      if(myEle.innerHTML == 'Fan Off')      {return;}
      if(myEle.innerHTML == 'Hotspot mode') {return;}
      if(myEle.innerHTML == 'WLAN mode')    {return;}

      if(myEle.innerHTML == 'Running'){
        LED_rotationcount = LED_stop;
        LED_sequencenum = 0;
        SHIELD_STATE = SHIELD_STATE_RUNNING;
        //SET_logoMain('', OFF);
      	LED_AllSetColor(RED);
	      LED_AllShow(ON);
        return;
      }
    
      LED_rotationcount = 0;
      LED_AllShow(ON);
      SET_logoMain('', ON);
     
      if(myEle.innerHTML == 'NOT RUNNING'){
        LED_patternnum = PAT_ROTATE_CW;
        LED_rotatecolor = GREEN;
        SHIELD_STATE = SHIELD_STATE_NOTRUNNING;
        //SET_logoMain('', ON);
        return;
      } 
      if(myEle.innerHTML == 'Time Error')   {
        LED_patternnum = PAT_ROTATE_CW;
        LED_rotatecolor = RED;
        SHIELD_STATE = SHIELD_STATE_TIMEERROR;
        //SET_logoMain('', ON);
        return;
      }

      if(myEle.innerHTML == 'Starting'){
        LED_patternnum = PAT_ROTATE_CW;
        LED_rotatecolor = RED;
        SHIELD_STATE = SHIELD_STATE_STARTING;
        //SET_logoMain('_dim', ON);
        return;
      } 

      if(myEle.innerHTML == 'ReStarting !!'){
        LED_patternnum = PAT_ROTATE_ACW;
        LED_rotatecolor = BLUE;
        SHIELD_STATE = SHIELD_STATE_RESTARTING;
        //SET_logoMain('_dim', ON);
        return;
      } 

      if(myEle.innerHTML == 'Rebooting !!'){
        LED_patternnum = PAT_ROTATE_CW;
        LED_rotatecolor = GREEN;
        SHIELD_STATE = SHIELD_STATE_REBOOTING;
        //SET_logoMain('_red_l', ON);
        return;
      } 
      
      if(myEle.innerHTML == 'CTRL-C'){
        LED_patternnum = PAT_ROTATE_ACW;
        LED_rotatecolor = RED;
        SHIELD_STATE = SHIELD_STATE_CTRLC;
        //SET_logoMain('_red_l', ON);
        return;
      } 

      if(myEle.innerHTML == 'DRIVE (EDIT)'){
        LED_patternnum = PAT_RANDOM;
        LED_rotatecolor = BLUE;
        SHIELD_STATE = SHIELD_STATE_DRIVEEDIT;
        //SET_logoMain('_blue_l', ON);
        return;
      } 

      if(myEle.innerHTML == 'DRIVE (CONFIG)'){
        LED_patternnum = PAT_RANDOM;
        LED_rotatecolor = GREEN;
        SHIELD_STATE = SHIELD_STATE_DRIVECFG;
        //SET_logoMain('_green_l', ON);
        return;
      } 
      
      if(myEle.innerHTML == 'UPDATING'){
        LED_patternnum = PAT_ROTATE_BOT;
        LED_rotatecolor = GREEN;
        SHIELD_STATE = SHIELD_STATE_UPDATING;
        WEAREUPDATING = true;
        //SET_logoMain('_yellow_l', ON);
      }
      
    } 
  } 
}

function rebootswitch() {shieldCommand_GET('1'); reloadpage('./home.html');}
function restartswitch(){shieldCommand_GET('2'); reloadpage('./home.html');}
function hotswitch()    {shieldCommand_GET('3'); reloadpage('./home.html');}
function fanswitch()    {shieldCommand_GET('4');}
function configswitch() {shieldCommand_GET('5');}
function logswitch()    {shieldCommand_GET('6');}
// function checkswitch()  {
  
//   let a = "";
//   const radioIds = ['default', '1', '2', '3'];
//         for (let id of radioIds) {
//           var myEle = DiD(id);
//           if (myEle && myEle.checked) {
//             console.log("Selected radio button ID:", myEle.id);
//             a = '&logfile=' + myEle.value;
//             return a; // Exit the loop once the selected radio is found
//           }
//           // if(myEle){
//           // a = '&logfile=' + myEle.value;
//   }
// }
function settingsread() {shieldCommand_GET('7');}

function shieldCommand_GET(str){
//    DiD('txtHint').innerHTML = '';
  let tagid = "";
  if(str == ''){return;}
  let args = "";
  if(str == '5'){
    if (AnyToWrite() == false){
      return;
    }
    if(ValidateForm() == false){
      return;
    }      
    args = MAKE_config();
  }
  if(str == '6'){args = MAKE_logname();}
  if(str == '7'){tagid = "01"; args = addit(tagid);}

  var xmlhttp=new XMLHttpRequest();
  xmlhttp.onreadystatechange=function(){
    if(this.readyState == 4 && this.status == 200){
      Ajax_Return(this.responseText);
      // console.log(this.responseText);
    }
  }

  reddot(ON);
  xmlhttp.open('GET','ZZ_shieldajax.php?rev=' + WEB_VER_ajax + '&q=' + str + args, true);
  xmlhttp.send();
}

function shieldCommand_POST(str){
  var data = new FormData();
  data.append('user', 'person');
  data.append('pwd', 'password');
  data.append('organization', 'place');
  data.append('requiredkey', 'key');

  var xhr = new XMLHttpRequest();
  xhr.open('POST', 'somewhere', true);
  xhr.onload = function () {
    // do something to response
    console.log(this.responseText);
  };
  xhr.send(data);
}

function Ajax_Return(basestring){
  if(basestring.substr(0, 8) == "LOGFILE:"){
    var myEle = DiD("log_file_text");
    if(myEle){
      myEle.value = basestring.substr(8);
    }
  } else {
    var linestring = basestring.split('//');
    for (var x = 0; x < linestring.length; x++){
      var tagid = linestring[x].split('=')[0];
      var tagval = linestring[x].split('=')[1];
      if(tagid == 'SHIELD_now_time'){
        if(Math.abs(T2S(tagval) - T2S(LASTTIMEWAS)) > READAGAINTIMEOUT){
          nreadbackId = setTimeout(doreadback, 1000);
        }
        LASTTIMEWAS = tagval;      
      }
      
      if(match_WEB_VER(tagid,tagval) == 0){
        if(match_SHIELD_setting(tagid,tagval) == 0){
          if(tagid == 'SHIELD_allstates'){
            allstates = tagval;
          } else {
            var myEle = DiD(tagid);
            if(myEle){
              if(myEle.type == "text"){
                myEle.value = tagval;
              } else if(myEle.type == "email"){
                myEle.value = tagval;
              } else if(myEle.type == "password"){
                myEle.value = tagval;
              } else {
                myEle.innerHTML = tagval;
              }
            }
          }
        }
      } 
    }
  }
  if(formready == OFF){
    formready = ON;
    LEDS_timer();
  }
  formready = ON;
  reddot(OFF);
}

function ValidateForm(){
  let tagid = "";
  var myEle_save = DiD('ShieldSetting_13_save');
  if(myEle_save){
    if(myEle_save.checked){
      tagid = "13"; if(!ValidateThis(tagid)){return false;}
      tagid = "14"; if(!ValidateThis(tagid)){return false;}
      tagid = "15"; if(!ValidateThis(tagid)){return false;}
      tagid = "16"; if(!ValidateThis(tagid)){return false;}
    }
  }
  update_user_status("Form Validated");
  return true;
}

function AnyToWrite(){
  let tagid = "";
  var myEle_save = null;
  let anyexist = false;
  
  tagid = 'ShieldSetting_02_save'; myEle_save = DiD(tagid); if(myEle_save){if(myEle_save.checked){return true;} anyexist = true;}
  tagid = 'ShieldSetting_03_save'; myEle_save = DiD(tagid); if(myEle_save){if(myEle_save.checked){return true;} anyexist = true;}
  tagid = 'ShieldSetting_07_save'; myEle_save = DiD(tagid); if(myEle_save){if(myEle_save.checked){return true;} anyexist = true;}
  tagid = 'ShieldSetting_09_save'; myEle_save = DiD(tagid); if(myEle_save){if(myEle_save.checked){return true;} anyexist = true;}
  tagid = 'ShieldSetting_10_save'; myEle_save = DiD(tagid); if(myEle_save){if(myEle_save.checked){return true;} anyexist = true;}
  tagid = 'ShieldSetting_13_save'; myEle_save = DiD(tagid); if(myEle_save){if(myEle_save.checked){return true;} anyexist = true;}
  if(anyexist){
    update_user_status("Nothing selected to update");
    return false;
  }
  return true;
}

function ValidateThis(id){
  let a = "";
  var myEle = DiD('ShieldSetting_' + id);
  if(myEle){
    if(myEle.type == "checkbox"){
      return true;
    } else if(myEle.type == "radio"){
      return true;
    } else if(myEle.value != undefined){
      if(myEle.value != ""){
        if (!myEle.checkValidity()) {
          a = "SET " + id;
          var myEle_label = DiD('ShieldSetting_' + id + '_lbl');
          if(myEle_label){a = myEle_label.innerHTML;}
          update_user_status(a + ' error ' + myEle.validationMessage);
          return false;
        }
      }
    }
  }
  return true;
}

function update_user_status(msg){
  var myEle_status = DiD('user_setting_status');
  if(myEle_status){
    myEle_status.innerHTML = msg;
  }
}

function addit(id){
  let a = "";
  let saveID = '00';
  var myEle = DiD('ShieldSetting_' + id);
  if(myEle){
    if(myEle.type == "checkbox"){
      if(myEle.checked){
        a = a + "&" + id + "=on";
      } else {
        a = a + "&" + id + "=off";
      }
    } else if(myEle.type == "radio"){
      if(myEle.checked){
        if(id == "03"){a = a + "&" + id + "=off";}
        if(id == "04"){a = a + "&" + id + "=join";}
        if(id == "09"){a = a + "&" + id + "=off";}
        if(id == "10"){a = a + "&" + id + "=off";}
      } else {
        if(id == "03"){a = a + "&" + id + "=on";}
        if(id == "04"){a = a + "&" + id + "=ap";}
        if(id == "09"){a = a + "&" + id + "=on";}
        if(id == "10"){a = a + "&" + id + "=on";}
      }
    } else if(myEle.value != undefined){
      if(myEle.value != ""){
        if (!myEle.checkValidity()) {
          update_user_status(myEle.validationMessage);
          return a;
        }
        a = a + "&" + id + "=" + myEle.value;
      }
    }
  }
  if(id == "01"){return a;}

  saveID = id;
  if(id == "04"){saveID = "03";}
  if(id == "05"){saveID = "03";}
  if(id == "06"){saveID = "03";}

  if(id == "08"){saveID = "07";}

  if(id == "11"){saveID = "10";}
  if(id == "12"){saveID = "10";}

  if(id == "14"){saveID = "13";}
  if(id == "15"){saveID = "13";}
  if(id == "16"){saveID = "13";}

  var myEle_save = DiD('ShieldSetting_' + saveID + '_save');
  if(myEle_save){
    if(myEle_save.type == "checkbox"){
      if(myEle_save.checked){} else {a = '';}
    }
  }
  return a;
}

// function MAKE_logname(){
//   let a = "";
//   let tagid = 'log_filename_list'
//   var myEle = DiD(tagid);
//   if(myEle){
//     a = '&logfile=' + myEle.value;
//     //a = '&logfile=' + myEle.options[myEle.selectedIndex].text;
//   }
//   return a;
// }

function MAKE_logname() {
  let a = "";
  const radioIds = ['default', '1', '2', '3'];
        for (let id of radioIds) {
          var myEle = DiD(id);
          if (myEle && myEle.checked) {
            console.log("Selected radio button ID:", myEle.id);
            a = '&logfile=' + myEle.value;
            return a; // Exit the loop once the selected radio is found
          }
          // if(myEle){
          // a = '&logfile=' + myEle.value;
  }
}

function MAKE_config(){
  let a = "";
  let tagid = ""
  tagid = "01"; a = a + addit(tagid);
  tagid = "02"; a = a + addit(tagid);
  tagid = "03"; a = a + addit(tagid);
  tagid = "04"; a = a + addit(tagid);
  tagid = "05"; a = a + addit(tagid);
  tagid = "06"; a = a + addit(tagid);
  tagid = "07"; a = a + addit(tagid);
  tagid = "08"; a = a + addit(tagid);
  tagid = "09"; a = a + addit(tagid);
  tagid = "10"; a = a + addit(tagid);
  tagid = "11"; a = a + addit(tagid);
  tagid = "12"; a = a + addit(tagid);
  tagid = "13"; a = a + addit(tagid);
  tagid = "14"; a = a + addit(tagid);
  tagid = "15"; a = a + addit(tagid);
  tagid = "16"; a = a + addit(tagid);
  if(a == ""){a = "&01=admsin&05=SSID&06=PASS";}
  return a;
}

function match_SHIELD_setting(h,v){
  let found = 0;
  if(h == "user_setting_status"){
   found = 1;
   var myEle = DiD(h);
   if(myEle){
      if (v != ""){
        myEle.innerHTML = v;
      }
    }
    return found;
  }

  if("ShieldSetting_" != h.substring(0, 14)){return found;}
  found = 1;
  var myEle = DiD(h);
  if(myEle){
    if(myEle.type == "radio"){
      if(h == "ShieldSetting_03"){myEle.checked = (v == "off");}
      if(h == "ShieldSetting_04"){
        if(v == "join"){myEle.checked = true;}
        else{
          var otherEle = DiD(h+'_ap');
          if(otherEle){otherEle.checked = true;}
        }
      }
      if(h == "ShieldSetting_09"){
        if(v == "off"){myEle.checked = true;}
        else{
          var otherEle = DiD(h+'_en');
          if(otherEle){otherEle.checked = true;}
        }
      }          
      if(h == "ShieldSetting_10"){
        var myEle_11 = DiD("ShieldSetting_11");
        var myEle_12 = DiD("ShieldSetting_12");
        var myEle_13 = DiD("ShieldSetting_13");
        var myEle_14 = DiD("ShieldSetting_14");
        var myEle_15 = DiD("ShieldSetting_15");
        var myEle_16 = DiD("ShieldSetting_16");

        if(v == "off"){
          if(myEle_11){myEle_11.disabled = false;}
          if(myEle_12){myEle_12.disabled = false;}
          if(myEle_13){myEle_13.disabled = false;}
          if(myEle_14){myEle_14.disabled = false;}
          if(myEle_15){myEle_15.disabled = false;}
          if(myEle_16){myEle_16.disabled = false;}
          myEle.checked = true;
        }
        else{
          var otherEle = DiD(h+'_en');
          if(otherEle){otherEle.checked = true;}
          if(myEle_11){myEle_11.disabled = true;}
          if(myEle_12){myEle_12.disabled = true;}
          if(myEle_13){myEle_13.disabled = true;}
          if(myEle_14){myEle_14.disabled = true;}
          if(myEle_15){myEle_15.disabled = true;}
          if(myEle_16){myEle_16.disabled = true;}
        }
      }
    } else if(myEle.type == "email"){
      myEle.value = v;
    } else if(myEle.type == "text"){
      myEle.value = v;
    } else if(myEle.type == "password"){
      myEle.value = v;
    } else {
      myEle.innerHTML = v;
    }
  }
  return found;
}

function match_WEB_VER(h,v){
  let found = 0;
  let hideit = 1;
  let tmpver = 0;
  let oldfile = 0;
  
  if("VER_" != h.substring(0, 4)){return found;}

  if(h == "VER_home_css"){
    found = 1;
    if(WEB_VER_home_css == 0){WEB_VER_home_css = v;}
    if(WEB_VER_home_css != v){oldfile = 1; tmpver = WEB_VER_home_css;}
  }
  if(h == "VER_home"){
    found = 1;
    hideit = 0;
    if(WEB_VER_home == 0){WEB_VER_home = v;}
    if(WEB_VER_home != v){oldfile = 1; tmpver = WEB_VER_home;}
  }

  if(h == "VER_css"){
    found = 1;
    if(WEB_VER_index_css == 0){WEB_VER_index_css = v;}
    if(WEB_VER_index_css != v){oldfile = 1; tmpver = WEB_VER_index_css;}
  }
  if(h == "VER_index"){
    found = 1;
    if(WEB_VER_index == 0){WEB_VER_index = v;}
    if(WEB_VER_index != v){oldfile = 1; tmpver = WEB_VER_index;}
  }
 
  if(h == "VER_info_css"){
    found = 1;
    if(WEB_VER_info_css == 0){WEB_VER_info_css = v;}
    if(WEB_VER_info_css != v){oldfile = 1; tmpver = WEB_VER_info_css;}
  }
  if(h == "VER_info"){
    found = 1;
    if(WEB_VER_info == 0){WEB_VER_info = v;}
    if(WEB_VER_info != v){oldfile = 1; tmpver = WEB_VER_info;}
  }

  if(h == "VER_logs_css"){
    found = 1;
    if(WEB_VER_logs_css == 0){WEB_VER_logs_css = v;}
    if(WEB_VER_logs_css != v){oldfile = 1; tmpver = WEB_VER_logs_css;}
  }
  if(h == "VER_logs"){
    found = 1;
    if(WEB_VER_logs == 0){WEB_VER_logs = v;}
    if(WEB_VER_logs != v){oldfile = 1; tmpver = WEB_VER_logs;}
  }

  if(h == "VER_settings_css"){
    found = 1;
    if(WEB_VER_settings_css == 0){WEB_VER_settings_css = v;}
    if(WEB_VER_settings_css != v){oldfile = 1; tmpver = WEB_VER_settings_css;}
  }
  if(h == "VER_settings"){
    found = 1;
    if(WEB_VER_settings == 0){WEB_VER_settings = v;}
    if(WEB_VER_settings != v){oldfile = 1; tmpver = WEB_VER_settings;}
  }

  if(h == "VER_style_css"){
    found = 1;
    if(WEB_VER_style_css == 0){WEB_VER_style_css = v;}
    if(WEB_VER_style_css != v){oldfile = 1; tmpver = WEB_VER_style_css;}
  }

  if(h == "VER_login"){
    found = 1;
    if(WEB_VER_login == 0){WEB_VER_login = v;}
    if(WEB_VER_login != v){oldfile = 1; tmpver = WEB_VER_login;}
  }

  if(h == "VER_logintest"){
    found = 1;
    if(WEB_VER_logintest == 0){WEB_VER_logintest = v;}
    if(WEB_VER_logintest != v){oldfile = 1; tmpver = WEB_VER_logintest;}
  }

  if(h == "VER_readsettings"){
    found = 1;
    if(WEB_VER_readsettings == 0){WEB_VER_readsettings = v;}
    if(WEB_VER_readsettings != v){oldfile = 1; tmpver = WEB_VER_readsettings;}
  }

  if(h == "VER_js"){
    found = 1;
    if(WEB_VER_js == 0){WEB_VER_js = v;}
    if(WEB_VER_js != v){oldfile = 1; tmpver = WEB_VER_js;}
  }

  if(h == "VER_ajax"){
    found = 1;
    if(WEB_VER_ajax == 0){WEB_VER_ajax = v;}
    if(WEB_VER_ajax != v){oldfile = 1; tmpver = WEB_VER_ajax;}
  }

  if(h == "VER_vers"){
    found = 1;
    if(WEB_VER_vers == 0){WEB_VER_vers = v;}
    if(WEB_VER_vers != v){oldfile = 1; tmpver = WEB_VER_vers;}
  } 

  if(h == "VER_app"){
    found = 1;
    if(WEB_VER_app == 0){WEB_VER_app = v;}
    if(WEB_VER_app != v){oldfile = 1; tmpver = WEB_VER_app;}
  } 

  if(h == "VER_os"){
    found = 1;
    if(WEB_VER_os == 0){WEB_VER_os = v;}
    if(WEB_VER_os != v){oldfile = 1; tmpver = WEB_VER_os;}
  } 

  if(h == "VER_vpn"){
    found = 1;
    if(WEB_VER_vpn == 0){WEB_VER_vpn = v;}
    if(WEB_VER_vpn != v){oldfile = 1; tmpver = WEB_VER_vpn;}
  } 

  if(found == 1){
    var myEle_row = DiD(h+'_row');
    var myEle = DiD(h);
    if(oldfile == 1){
      WEB_FLASH_count++;
      if(WEB_FLASH_count == 10){
        WEB_FLASH = !WEB_FLASH;
      } else if(WEB_FLASH_count >= 20){
        WEB_FLASH_count=0;
        WEB_FLASH = !WEB_FLASH;
      }
      
      DOT_color = 'red';
      if(myEle_row){myEle_row.style.display = 'block';}
      if(myEle){
        if(WEB_FLASH){
          myEle.innerHTML = v;
          myEle.style.color = 'yellow';
        } else {
          myEle.innerHTML = tmpver;
          myEle.style.color = DOT_color;
        }
      }
    } else {
      if(hideit == 1){
        if(myEle_row){myEle_row.style.display = 'none';}
      } else {
        if(myEle_row){myEle_row.style.display = 'block';}
      }
      if(myEle){
        myEle.innerHTML = v;
        myEle.style.color = null;
      }
    }
  }
  return found;
}

function DiD(id){
  return document.getElementById(id);
}
  
nIntervId =1;
dospanner(); // this just sets the first timer going on load
if(DiD('ShieldSetting_01_lbl')){settingsread();}
console.warn("WHAT ARE YOU LOOKING AT.?.");