/* Create a dummy dataset used to create a chart series */
let dataset = "[300]0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 536,536 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 536,1586 6278,4244 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 536,2658 6814,4244 536,536 0,0 0,0 0,0 0,0 0,0 0,0 536,536 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 536,536 0,0 0,0 0,0 0,0 0,0 0,0 0,1072 0,0 536,536 6814,5830 0,0 0,0 536,0 0,536 0,0 0,0 0,0 0,0 0,0 0,536 536,0 0,0 0,0 0,0 536,0 0,536 0,0 0,0 0,0 0,0 0,0 0,0 0,0 4156,1586 5896,7482 0,1072 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0 0,0";

/* Create a series using the dummy dataset for the chart data */
let series = getSeries(dataset,1);

/* Function to update the VPN state text color */
function updateStatusColor(value) {
    const statusText = document.getElementById('VPN_state');
    if (value === 'Control port OPEN') {
        statusText.textContent = value;
        statusText.classList.add('status-active');
        statusText.classList.remove('status-inactive');
    } else if (value === 'Control port CLOSED'){
        statusText.textContent = value;
        statusText.classList.add('status-inactive');
        statusText.classList.remove('status-active');
    }else {
        statusText.textContent = value;
        statusText.classList.add('status-active');
        statusText.classList.remove('status-inactive');
    }
}

/* Function to extract series data from the dataset string extracted from the bandwidth cache */
function getSeries(dataset,matchval) {
    // Remove the [300] prefix
    dataset = dataset.replace("[300]", "");
    // Extract pairs of numbers
    const pattern = /(\d+),(\d+)/g;
    let match;
    const series = [];
    while (match = pattern.exec(dataset)) {
        const firstValue = parseInt(match[matchval]);
        series.push(firstValue);
    }
    // Get the last 120 first values and reverse the order
    const last120Values = series.slice(-120).reverse();

    // Get the first 120 values
    //const first120Values = series.slice(0, 120);

    // Return the series data
    return [{ data: last120Values }];
}

/* Read the data from (00_vpnstatus.txt) and update webFORM */
function FetchData_vpn_status() {
  fetch('php/get_vpn_data.php')
      .then(response => response.json())
      .then(data => {
          // Accessing the variables from the JSON response
        let vpn_now_time = data.VPN_now_time;
        let vpn_installed = data.VPN_installed;
        let vpn_state = data.VPN_state;
        let vpn_version = data.VPN_version;
        let vpn_start_time = data.VPN_start_time;
        let vpn_total_run_time = data.VPN_total_run_time;
        let vpn_bootstrap_phase = data.VPN_bootstrap_phase;
        let vpn_total_read = data.VPN_total_read;
        let vpn_total_written = data.VPN_total_written;
        let vpn_bandwidth_cache = data.VPN_bandwidth_cache;
        let vpn_nickname = data.VPN_nickname;
        let vpn_flags = data.VPN_flags;
        let vpn_bandwidth_concensus = data.VPN_bandwidth_concensus;
        let vpn_download_bytessec = data.VPN_download_bytessec;
        let vpn_upload_bytessec = data.VPN_upload_bytessec;
        let vpn_download_avg = data.VPN_download_avg;
        let vpn_upload_avg = data.VPN_upload_avg;
        let vpn_cpu_usage = data.VPN_CPU_usage;
        let vpn_ram_usage = data.VPN_RAM_usage;

        // Display the data on the web page  
        //document.getElementById('vpnData').textContent = JSON.stringify(data, null, 2);
        document.getElementById('VPN_now_time').textContent = data.VPN_now_time;
        //document.getElementById('VPN_installed').textContent = vpn_installed;
        document.getElementById('VPN_state').textContent = vpn_state;
        updateStatusColor(vpn_state);

        document.getElementById('VPN_version').textContent = vpn_version;
        document.getElementById('VPN_start_time').textContent = vpn_start_time;
        document.getElementById('VPN_total_run_time').textContent = vpn_total_run_time;
        document.getElementById('VPN_bootstrap_phase').textContent = vpn_bootstrap_phase;
        document.getElementById('VPN_total_read').textContent = vpn_total_read;
        document.getElementById('VPN_total_written').textContent = vpn_total_written;
        //document.getElementById('VPN_nickname').textContent = vpn_nickname;
        document.getElementById('VPN_flags').textContent = vpn_flags;
        document.getElementById('VPN_bandwidth_concensus').textContent = vpn_bandwidth_concensus;

        document.getElementById('VPN_download_bytessec').textContent = vpn_download_bytessec + ' B/s';
        document.getElementById('VPN_upload_bytessec').textContent = vpn_upload_bytessec + ' B/s';
        document.getElementById('VPN_download_avg').textContent = vpn_download_avg;
        document.getElementById('VPN_upload_avg').textContent = vpn_upload_avg;

        /* extract the series data from the bandwidth cache string */
        let dataset = vpn_bandwidth_cache;
        let download_series = getSeries(dataset,1);
        let uploadd_series = getSeries(dataset,2);

        /* Update chart data with download/upload series data */ 
        barChart_download.updateSeries(download_series,false);
        barChart_upload.updateSeries(uploadd_series,false);

        document.getElementById('VPN_CPU_usage').textContent = vpn_cpu_usage;
        document.getElementById('VPN_RAM_usage').textContent = vpn_ram_usage;
      })
      .catch(error => console.error('Error:', error));
}

/* Initialise a chart options variable for Download Chart */
var barChartOptions_download = {
    colors: ["#2e7d32"],
    series: series,
        chart: {
        type: 'line',
        toolbar: {
            show: false,
        },
        height: 250,
        sparkline: {
            enabled: true,
        },
    },
    title: {
        text: 'DOWNLOAD',
        align: 'right',
        margin: 10,
        offsetX: 0,
        offsetY: 0,
        floating: false,
        style: {
          fontSize:  '14px',
          fontWeight:  'bold',
          fontFamily:  undefined,
          color:  '#2e7d32'
        },
    },  
    stroke: {
        curve: 'stepline',
        show:true,
        width: 2,
    },
    xaxis: {
        tickAmount: 3,
        labels: {
            style: {
                colors: "#f5f7ff",
            },
        },
    },
    yaxis:{
        title: {
            text: 'BYTES',
            style: {
                color: "#f5f7ff",
            },
        },
        labels: {
            style: {
                colors: "#f5f7ff",
            },
        },
    },      
    fill: {
        opacity:1
    },
  dataLabels: {
    enabled: false
  },
  markers: {
    hover: {
      sizeOffset: 4
    }
  }
  };

  /* Initialise a chart options variable for Upload Chart */
var barChartOptions_upload = {
    colors: ["#ff6d00"],
    series: series,
        chart: {
        type: 'line',
        toolbar: {
            show: false,
        },
        height: 250,
        sparkline: {
            enabled: true,
        },
    },
    title: {
        text: 'UPLOAD',
        align: 'right',
        margin: 10,
        offsetX: 0,
        offsetY: 0,
        floating: false,
        style: {
          fontSize:  '14px',
          fontWeight:  'bold',
          fontFamily:  undefined,
          color:  '#ff6d00'
        },
    },  
    stroke: {
        curve: 'stepline',
        show:true,
        width: 2,
    },
    xaxis: {
        tickAmount: 3,
        labels: {
            style: {
                colors: "#f5f7ff",
            },
        },
    },
    yaxis:{
        title: {
            text: 'BYTES',
            style: {
                color: "#f5f7ff",
            },
        },
        labels: {
            style: {
                colors: "#f5f7ff",
            },
        },
    },

    fill: {
        opacity:1
    },
  dataLabels: {
    enabled: false
  },
  markers: {
    hover: {
      sizeOffset: 4
    }
  }
  };

  var barChartOptions_CPU_RAM = {
    series: [70],
    chart: {
    height: 350,
    type: 'radialBar',
  },
  plotOptions: {
    radialBar: {
      hollow: {
        size: '70%',
      }
    },
  },
  labels: ['CPU'],
  };


/* Initialise the download chart and render*/
var barChart_download = new ApexCharts(document.querySelector("#download-chart"), barChartOptions_download);
barChart_download.render();

/* Initialise the upload chart and render */
var barChart_upload = new ApexCharts(document.querySelector("#upload-chart"), barChartOptions_upload);
barChart_upload.render();

//var barChartOptions_CPU_RAM = new ApexCharts(document.querySelector("#VPN_CPU_usage"), barChartOptions_CPU_RAM);
//barChartOptions_CPU_RAM.render();

// Fetch VPN status immediately, and then every 750 mSeconds
FetchData_vpn_status();
setInterval(FetchData_vpn_status, 750);
