#!/bin/bash

LOGFILE="/home/relayup/dev/renamewlan.log"

exec > >(tee -a $LOGFILE 2>&1)

if [[ ! -f /sys/class/net/wlan1/address ]];then

    if [[ -n $(cat /sys/class/net/wlx*/address | head -1) ]];then

        if [[ "$(stat -c%s "$LOGFILE")" -ge "$((5 * 1048576))" ]]; then
            rm $LOGFILE
        fi

        echo -e "\n$(date): Renaming USB NIC to wlan1"
        usbwifi_attr=$(cat /sys/class/net/wlx*/address | head -1)        
        echo "SUBSYSTEM==\"net\", ACTION==\"add\", ATTR{address}==\"$usbwifi_attr\", NAME=\"wlan1\"" | tee -a /etc/udev/rules.d/70-persistent-net.rules
        echo "R" | tee /home/relayup/dev/html-normal/00_dothis.txt
    fi

fi