#!/bin/bash

CURRENT_VERSION=$(grep -a SHIELD_build_version /home/relayup/dev/Shield | sed 's/\$.*//' | sed 's/\.//g')

if [[ "$CURRENT_VERSION" -lt "200" ]];then
    echo "$(date +'%Y-%m-%d %H:%M:%S') - APP version must be 2.0.0 or above to update with this method. Contact ANYONE support at support@anyone.io" | tee -a /mnt/usb/contact_support.log
    rm /mnt/usb/default.cfg
    exit
fi

rm -r /home/relayup/dev/html-normal
rm -r /home/relayup/dev/html-wizard
unzip -o /mnt/usb/update.zip '00_template.cfg' 'AP_*.cmds' '*rc.txt' 'vpn_install.cfg'  -d /home/relayup/dev/
unzip -q -o /mnt/usb/update.zip 'html-normal/*' 'html-wizard/*' -d /home/relayup/dev/

unzip -q -o '/mnt/usb/update.zip' 'etc/*' -d /
unzip -q -o '/mnt/usb/update.zip' 'bin/*' -d /usr/
unzip -q -o '/mnt/usb/update.zip' 'include/*' -d /usr/
unzip -q -o '/mnt/usb/update.zip' 'lib/*' -d /usr/
unzip -q -o '/mnt/usb/update.zip' 'share/*' -d /usr/
unzip -q -o '/mnt/usb/update.zip' 'peaq/*' -d /home/relayup/dev/
unzip -q -o '/mnt/usb/update.zip' 'onboot' -d /etc/cron.d/
chmod +x /home/relayup/dev/peaq/node_modules/.bin/tsx
chmod +x /home/relayup/dev/peaq/node_modules/@esbuild/linux-arm64/bin/esbuild

unzip -o /mnt/usb/update.zip 'html-hs.conf' -d /etc/apache2/sites-available/
mkdir /home/relayup/dev/html-hs
unzip -q -o /mnt/usb/update.zip 'html-hs/*' -d /home/relayup/dev/

chown -R relayup:relayup /home/relayup/dev/html-*
chmod 777 /home/relayup/dev/html-*

chown relayup:relayup /home/relayup/dev/vpn_install.cfg
chmod 644 /home/relayup/dev/vpn_install.cfg
chown www-data:www-data /home/relayup/dev/vpn_config.cfg
chmod 644 /home/relayup/dev/vpn_config.cfg

chown relayup:relayup /home/relayup/dev/AP_*.cmds
chmod 644 /home/relayup/dev/AP_*.cmds

chown relayup:relayup /home/relayup/dev/*rc.txt
chmod 644 /home/relayup/dev/*rc.txt

mkdir /home/relayup/dev/sysupdate
chown www-data:www-data /home/relayup/dev/sysupdate
chmod 777 /home/relayup/dev/sysupdate

chmod 777 /home/relayup/dev

sed -i '/CustomLog\ \/access.log\ combined/d' /etc/apache2/sites-available/000-default.conf
sed -i '/ErrorLog\ \/error.log/d' /etc/apache2/sites-available/000-default.conf
sed -i 's/30_Set=208.67.222.222/30_Set=1.1.1.1/g' /home/relayup/dev/00_saved.cfg
sed -i 's/^BandwidthRate\b/RelayBandwidthRate/g' /home/relayup/dev/vpn_config.cfg
sed -i 's/^BandwidthBurst\b/RelayBandwidthBurst/g' /home/relayup/dev/vpn_config.cfg

## Cleanup
sed -i '/renamewlan.sh/d' /etc/cron.d/onboot 
rm /var/spool/cron/crontabs/root
rm /error.log
rm /access.log
rm /home/relayup/dev/html-wizard/default.cfg
rm /home/relayup/dev/html-normal/default.cfg
rm /home/relayup/dev/html-wizard/temp_*
rm /home/relayup/dev/html-normal/temp_*
rm /home/relayup/dev/00_logs.log
rm /renamewlan.sh
rm /dependencies.sh
rm /update.sh
find /home/ -type f -name ".DS_Store" -delete
find /home/ -type f -name "._*" -delete
find /home/ -type d -name "__MACOSX" -delete

unzip -o /mnt/usb/update.zip 'renamewlan.sh' -d /home/relayup/dev/
chmod 755 /home/relayup/dev/renamewlan.sh

## Modify eth0
echo -e '#!/bin/sh\nethtool --offload eth0 gso on sg on gro off rx off tx off' > /etc/NetworkManager/dispatcher.d/99-ethtool-settings.sh
chmod +x /etc/NetworkManager/dispatcher.d/99-ethtool-settings.sh

## Disable console auto-login
sed -i '/ExecStart=-\/sbin\/agetty --autologin root/d' /lib/systemd/system/serial-getty@.service
sed -i '/^#ExecStart=-\/sbin\/agetty -o/s/^#//' /lib/systemd/system/serial-getty@.service

## Enable i2c7 interface
sed -i 's/intfc:i2c7=off/intfc:i2c7=on/g' /boot/hw_intfc.conf

if [[ $(grep -c "29_Set=off" /home/relayup/dev/00_saved.cfg) -eq 1 ]];then
    grep "01_Set=" /home/relayup/dev/00_saved.cfg > /home/relayup/dev/00_websaved.cfg
    echo "29_Set=relay" >> /home/relayup/dev/00_websaved.cfg
    echo "30_Set=1.1.1.1" >> /home/relayup/dev/00_websaved.cfg
fi

if [[ $(dpkg -l 'anon' | grep -w 'anon' | awk '{print $1}') == 'iHR' ]];then
    sudo dpkg --configure -a
fi

if [[ $(systemctl list-unit-files anon.service | grep -c 'masked') -eq 1 ]];then
    systemctl unmask anon.service
fi

rm /var/lib/php/sessions/*

unzip -o /mnt/usb/update.zip 'Shield' -d /home/relayup/dev/
chown root:root /home/relayup/dev/Shield
chmod 774 /home/relayup/dev/Shield

echo "$(date +"%Y-%m-%d %H:%M:%S") - Relay with serial 0x$(cat /proc/cpuinfo | grep Serial | cut -d' ' -f2 | tr '[:lower:]' '[:upper:]') was updated." \
| tee -a /mnt/usb/updated_0x$(cat /proc/cpuinfo | grep Serial | cut -d' ' -f2 | tr '[:lower:]' '[:upper:]')_$(date +"%Y%m%d_%H%M%S").log