'use strict';

const axios = require('axios');

module.exports = {

    async receive(context) {

        if (context.messages.webhook) {
            const data = context.messages.webhook.content.data;
            await context.sendJson(data, 'out');
            return context.response();
        }
    },

    async start(context) {

        const config = {
            headers: { Authorization: `Bearer 0r75vO1sFzAq1zQCUeWhrigAuc3NoK8L` }
        };

        const bodyParameters = {
               "name": "order-management.request-for-quote.submitted",
               "method": "Url",
               "metadata": {
                   "url": "https://2.none.appmixer.cloud/flows/90bd2685-3878-473c-9c55-370daaa0d109/components/9f4f0bbe-9fda-4c49-b493-ca3b44ee97d61234578912465",
                   "email": {
                       "to": "",
                       "cc": ""
                   }
               },
               "enabled": true,
               "isEmailCcActive": false,
               "isEmailToActive": false,
               "useTradingEmail": true
        };

        //const { apiKey } = context.auth;
        //const url = context.config.baseUrl + '/webhooks';
        const url = 'https://api.shipservlabs.com/notifications/subscriptions';

        const { data } = await axios.post(url, bodyParameters, config);

        //await context.log(data);

        return context.saveState({ webhookId: data.id });
    },

    async stop(context) {

        //const { apiKey } = context.auth;
        //const url = context.config.baseUrl + '/webhooks';
        const url = 'https://api.shipservlabs.com/notifications/subscriptions';

        return axios.delete(url + '/' + context.state.webhookId, {
            headers: {
            }
        });
    }
};

/*
module.exports = {

    async receive(context) {
        if (context.messages.webhook) {
            const { data } = context.messages.webhook.content;
            if (data.event === 'todo-created') {
                return context.sendJson(data.todo, 'out');
            }
        }
    },

    async start(context) {
        const { apiKey } = context.auth;
        const url = context.config.baseUrl + '/webhooks';
        const { data } = await context.httpRequest.post(url, { url: context.getWebhookUrl() }, {
            headers: {
                'X-Api-Key': apiKey,
                'Content-Type': 'application/json'
            }
        });
        return context.saveState({ id: data.id });
    },

    async stop(context) {
        const { apiKey } = context.auth;
        const url = context.config.baseUrl + '/webhooks';
        return context.httpRequest.delete(url + '/' + context.state.id, {
            headers: {
                'X-Api-Key': apiKey
            }
        });
    }
};
*/
